/* Wiktor Zychla, 2003 */
using System;
using System.Text;

namespace Example
{
  public class CMain
  {    
    struct RomanNumeral
    {
      readonly string[] literals;
      int value;

      public RomanNumeral( int value )
      {
        if ( value > 3999 ) throw new ArgumentOutOfRangeException();

        literals = new string[] { "I", "V", "X", "L", 
                                  "C", "D", "M" };        
        this.value = value;
      }

      public static explicit operator RomanNumeral( int value )
      {
        return new RomanNumeral( value );
      }

      public static implicit operator int(RomanNumeral roman)
      {
         return roman.value;
      }

      string BuildRomanString( int index, int v )
      {  
         if ( v <= 0 ) return String.Empty;       

         string  s = String.Empty;
         int digit = v%10;
         int j;

         if ( digit == 4 ) 
           s = literals[index]+literals[index+1]+s;
         else if ( digit == 9 ) 
           s = literals[index]+literals[index+2]+s;
         else if ( digit >= 5 && digit <= 8 )         
         {
            s = literals[ index+1 ];
            digit -= 5;
         }
         if ( digit >= 1 && digit <=3 )
         {
            for ( j=0; j<digit; j++ )
              s = s+literals[ index ];
         } 

         return BuildRomanString( index+2, v/10 )+s;
      }
    
      public override string ToString()
      {
        string s = String.Empty;
        int tVal = value;

        return BuildRomanString( 0, value );
      }
    }

    public static void Main()
    {
      int          i = 2003;
      RomanNumeral r = (RomanNumeral)i;
      int          j = r;

      Console.WriteLine( "{0}, {1}, {2}", i, r, j );
    }
  }
}
